package client_server;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;

import javax.swing.JOptionPane;

public class Client {
	 MainForm mainForm;
	 Player player;
	 ServicesInterface myServerObject;
	 String[] info;
	static protected Client instance;
	
	
	
	public static void main(String[]args)
	{
		
		Client c = new Client();
		instance=c;
		c.run();
	}
	
	
	
	public  void run() {
	    final String serverName=JOptionPane.showInputDialog("ip server");
//		String serverName = "127.0.0.1";
//		System.setProperty("java.security.policy","file:/Users/DeLac/eclipse_wrksp/hermes_android/GDR/wideopen.policy");
//    	System.setProperty("java.rmi.server.codebase","file:/Users/DeLac/eclipse_wrksp/hermes_android/GDR/bin/");
    	System.setProperty("java.security.policy","http://dl.dropbox.com/u/13520648/wideopen.policy");
    	System.setProperty("java.rmi.server.codebase","http://dl.dropbox.com/u/13520648/");
    	

    	if (System.getSecurityManager() == null)
    	System.setSecurityManager(new RMISecurityManager());
    	
    	
		info = new String[7];

		final String nome=JOptionPane.showInputDialog("scegli nome");
		//final String nome="daniele";
		
		try {
			// bind server object to object in client
			System.out.println("connessione in corso...");
			myServerObject = (ServicesInterface) Naming.lookup("rmi://" + serverName + "/myRMIImplInstance");
			System.out.println("connesso");
			java.awt.EventQueue.invokeLater(new Runnable() {
				public void run() {					
					Player player = new Player(nome);
					mainForm = new MainForm(player);
					mainForm.setVisible(true);
					aggiornaInfo();
					try {
						myServerObject.bornPlayer(info);
					} catch (RemoteException e) {
						e.printStackTrace();
					}
				}
			});
			while( mainForm==null)
			  {
				Thread.sleep(2000);// gli do il tempo di creare il pupazzo
			  }
			while (true) {
				String[] info = { mainForm.getMainPlayer().nome_player,
								  mainForm.getMainPlayer().stato,
								  mainForm.getMainPlayer().orientation,
								  "" + (mainForm.getMainPlayer().getLocation().x),
								  "" + (mainForm.getMainPlayer().getLocation().y) 
								 };
				myServerObject.setPlayerInfo(info);
				mainForm.updateRemotePlayers(myServerObject.getRemotePlayersInfo());
				Thread.sleep(40);
			}
		} catch (Exception e) {
			System.out.println("CLIENT Exception occured: " + e);
			e.printStackTrace();
			System.exit(0);
		}
		System.out.println("RMI connection successful");
	}

	
	public  void disconnetti(){
		try {
			myServerObject.killPlayer(info[0]);
			System.out.println(info[0]+" disconnesso");
		} catch (RemoteException e) {
			e.printStackTrace();
		}		
	}
	
	public void assegnaColpo(String nemico, Point p)
	{
		try {
			myServerObject.assegnaColpo(nemico, p);
			
		} catch (RemoteException e) {e.printStackTrace();}
	}
	
	public void colpoRicevuto(String nemico)
	{
		try {
			myServerObject.colpoRicevuto(nemico);
		} catch (RemoteException e) {e.printStackTrace();}
	}
	
	public  void aggiornaInfo(){
		info[0]=mainForm.getMainPlayer().nome_player;
		info[1]=mainForm.getMainPlayer().stato;
		info[2]=mainForm.getMainPlayer().orientation;
	    info[3]="" + mainForm.getMainPlayer().getLocation().x;
		info[4]="" + mainForm.getMainPlayer().getLocation().y ;		
	}
	
	public String leggiOstacoli(){
		try {
			return(myServerObject.leggiOstacoli());
		} catch (RemoteException e) {
			e.printStackTrace();
			return null;
		}
	        
	}
	
	
}